---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Equivalence
  - Isomorphism
---

# Equivalence : Isomorphism (relation)

> Same structure under relabeling; functionally interchangeable within a context.

---

## Definition

- Structure sameness test
- Function match check
- Map preservation rule
- Exchange validity

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Structure same | Form match | `Monitor`, `Same` |
| Function map | Role swap | `Check`, `Map` |
| Valid swap | Can change | `Test`, `Swap` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Structure same | Looks alike | "Just like it" |
| Function map | Works same | "Does same" |
| Valid swap | Can replace | "Fits in" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Form match | Looks alike | How same works |
| Role swap | Works same | How match flows |
| Can change | Can replace | How swap fits |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | State same | Force match |
| Networks | Node swap | Link same |
| Cognition | Mind match | Think same |
| Systems | Flow same | Move match |

---

## Scale Effects

How Equivalence manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum same | Wave match |
| λV | Gate swap | State same |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase same | Pattern match |
| ∇S | Structure swap | Clear same |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave same | Light match |
| λV | Field swap | Space same |

Note: At extreme scales, equivalence faces fundamental limits (e.g., quantum sameness at ε, causal matching at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: match precision
- c: swap speed
- ψA: phase same
- λV: gate match

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern same | Wave match |
| Human | λV | Gate swap | Flow same |
| Cosmic | ψA | Phase match | Field swap |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | False same | Pattern mismatch | Not alike |
| Human | Bad swap | Flow break | Won't fit |
| Cosmic | Match fail | Field clash | Not same |

---

## Diagnostic Checklist

Technical tests:
- [ ] Same checked
- [ ] Map works
- [ ] Swap valid
- [ ] Match holds

Humane tests:
- [ ] Looks right
- [ ] Works same
- [ ] Fits well
- [ ] Feels match

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical isomorphism nor experiential sameness alone captures its full meaning.

---

## See Also

- [[Symmetry : Asymmetry (relation)]]
- [[Compatibility : Conflict (relation)]]
- [[Dependency : Constraint (relation)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented